/*
TAPEINFO is a Linux utility to dump the inquiry and log pages of the
Hewlett-Packard C1533A tape drive.

Copyright 1995 Eric L. Smith

TAPEINFO is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License version 2 as published by the Free
Software Foundation.  Note that I am not granting permission to redistribute
or modify TAPEINFO under the terms of any later version of the General Public
License.

This program is distributed in the hope that it will be useful (or at least
amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License along with
this program (in the file "COPYING"); if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

$Header: /usr/home/kolwynia/eric/tapeinfo/RCS/modesense.c,v 1.5 1995/09/11 18:20:50 eric Exp eric $
*/

#include <stdio.h>

#include "tapeinfo.h"
#include "scsicmd.h"
#include "modesense.h"

void print_mode_sense_page (FILE *f, int fd, unsigned char page)
{
  unsigned long count, len;
  int i;

  unsigned char cmd [] = { T_MODE_SENSE,
			     0x08,  /* LUN, DBD */
			     0x00,  /* page */
			     0x00,  /* reserved */
			     0xff,  /* allocation length */
			     0x00   /* control */
			 };

  fprintf (f, "Mode Sense page %02x:\n", page);
  cmd [2] = page;
  count = scsi_command (fd, cmd, sizeof (cmd), buf2, 0xff);
  len = buf2 [0] + 1;

  hex_dump (f, buf2, len);
}


void print_mode_sense_pages (FILE *f, int fd, int all)
{
  unsigned long count, len;
  int i;
  int page;

  unsigned char cmd [] = { T_MODE_SENSE,
			     0x08,  /* LUN, DBD */
			     0x3f,  /* all pages */
			     0x00,  /* reserved */
			     0xff,  /* allocation length */
			     0x00   /* control */
			 };

  count = scsi_command (fd, cmd, sizeof (cmd), buf1, 0xff);
  len = buf1 [0] + 1;

  if (! all)
    fprintf (f, "Available Mode Sense pages:\n");
  for (i = 4; i < len; i += buf1 [i+1] + 2)
    {
      page = buf1 [i];
      if (all)
	{
	  print_mode_sense_page (f, fd, page);
	  fprintf (f, "\n");
	}
      else
	fprintf (f, "%02x ", page);
    }
  if (! all)
    fprintf (f, "\n");
}


