
// Get decimal number from line in control file

char *get_decimal(char *text, int *val)
{
	int	result;
	char	c;

	result = 0;
	c = toupper(*text);

	while (c)
	{
		if (c == ';')			// beginning of comment, ignore all else
			break;

		if (isdigit(c))
		{
			c -= '0';
			result *= 10;
			result += ((int) c & 0xf);
			text++;
		}
		else
			break;

		c = toupper(*text);	// get next digit
	}

	*val = result;				// pass number back to caller
	return(text);				// and return updated text pointer
}

//
// Get hexadecimal number from line in control file.
// Return updated character pointer.
// If number preceeded by '#', then evaluate as a decimal number
//

char *get_adrs(char *text, int *val)
{
	int	result, start;
	char	c;

	result = start = 0;
	c = toupper(*text);

	while (c)
	{
		if (c == ';')			// beginning of comment, ignore all else
			break;

		if (c == '\n')			// necessary because isspace() includes \n
			break;

		if (isspace(c))		// skip leading whitespace
		{
			text++;

			if (start)			// if result already begun...
				break;
		}
		else if (isxdigit(c))
		{
			start = 1;			// flag beginning of result conversion
			c = (c > '9') ? c - 0x37 : c - 0x30;
			result <<= 4;
			result |= ((int) c & 0xf);
			text++;
		}
		else if ((c == 'X') && !result && (start == 1))	// allow for prefix "0x"
		{
			start++;
			text++;
		}
		else if (c == '#')
		{
			text++;
			return get_decimal(text, val);
		}
		else						// done if not hexadecimal character
			break;

		c = toupper(*text);	// get next digit
	}

	*val = result;				// pass number back to caller
	return(text);				// and return updated text pointer
}

